%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Function name: read_picarro_ch4
%
% Scope:    import PICARRO G2401 data file
%
% Input:    file name G2401 data file (string)
%           directory G2401 data file (string)
%           index plot requested (double)
%
% Output:   "data_ch4" struture containing raw data from G2401
%           overview figure (if requested)   
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function data_ch4 = read_picarro_ch4(filename_ch4,pathname_ch4, plot_requested)

tic;fprintf('Running function read_picarro_ch4...\n');

datatable = readtable([pathname_ch4 filename_ch4]);

data_ch4.all(:,1) = datatable.('FRAC_HRS_SINCE_JAN1');     %absolute time in h
data_ch4.all(:,2) = data_ch4.all(:,1)-data_ch4.all(1,1);         %relative time in h
data_ch4.all(:,3) = datatable.('CH4');  
data_ch4.all(:,4) = datatable.('CO');  
data_ch4.all(:,5) = datatable.('CO2');  
data_ch4.all(:,6) = datatable.('H2O'); 
data_ch4.all(:,7) = datatable.('CavityPressure');  
data_ch4.all(:,8) = datatable.('CavityTemp'); 

data_ch4.start_time=data_ch4.all(1,1);
data_ch4.end_time=data_ch4.all(end,1);

date_string=datatable.('DATE');
time_string=datatable.('TIME');

data_ch4.start_time_string=join([string(date_string(1,1)) string(time_string(1,1))]);
data_ch4.end_time_string=join([string(date_string(end,1)) string(time_string(end,1))]);

data_ch4.data_idx=1;    %index to keep track if a file is uploaded

%% define variable names for plot labels (with units)

data_ch4.varlabels ={join(['Time [h] since',extractBefore(data_ch4.start_time_string,5),'-01-01 00:00:00']),...
                    join(['Time [h] since',extractBefore(data_ch4.start_time_string,20)]),...
                    'CH_4 [ppm]',...
                    'CO [ppm]',...        
                    'CO_2 [ppm]',...        
                    'H_2O [%]',...
                    '{\itp}_{Cell} [mTorr]',...
                    '{\itT}_{Cell} [°C]'};

%% plot overview

plotvars=[3 6 4 7 5 8];
if plot_requested
    figure;
    for i=1:6
        subplot(3,2,i);
        plot(data_ch4.all(:,2),data_ch4.all(:,plotvars(1,i)),'-r','LineWidth',1.5);
        hold on;
        grid on;
        box on;
        xlim([data_ch4.all(1,2) data_ch4.all(end,2)]);
        ylabel({sprintf('%s',data_ch4.varlabels{1,plotvars(1,i)})},'fontsize',12);
        if i==1
        title('Overview PICARRO G2401','fontsize',12); end    
        if i==5 || i==6
        xlabel({sprintf('%s',data_ch4.varlabels{1,2})},'fontsize',12); end
    end
    
    x0 = 10;
    y0 = 50;
    ww = 900;
    hh = 700;
    set(gcf,'units','points','position',[x0,y0,ww,hh]);
    set(gcf,'Units','Inches');
    pos = get(gcf,'Position');
    set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3),pos(4)]);
end

%%
time_elapsed=toc; fprintf('read_picarro_ch4 completed (execution time: %1.2f s)\n',time_elapsed); 

end